﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

//
using System.Data.SqlClient;
using DotNet.FrameWork.Data;
using System.Text;
using System.Security.Cryptography;
using System.Data;
namespace HteamFeedback.Web.Admin
{
    public partial class Admin_Login : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        protected void bt_login_Click(object sender, EventArgs e)
        {
            if (this.txtValidateNum.Text == Session["validateNum"].ToString())
            {
                Session.Clear();
                string _userName = this.txtUsername.Text.Trim();
                string _userPsw = this.txtUserpassword.Text.Trim();
                bool num = Exists(_userName, MD5(_userPsw));
                if (num == false)
                {
                    Response.Write("<script> alert('用户名或密码错误，请重新输入！'); location='Admin_Login.aspx'</script>");
                }
                else
                {
                    Session["user_status"] = "true";
                    Response.Redirect("/Admin/Admin_index.aspx");
                }
            }
            else
            {
                Response.Write("<script> alert('验证码输入错误，请重新输入！');location='Admin_Login.aspx'</script>");
            }
        }
        /// <summary>
        /// 判断用户是否存在
        /// </summary>
        /// <param name="_userName">用户名</param>
        /// <param name="_userPsw">密码</param>
        /// <returns></returns>
        public bool Exists(string _userName, string _userPsw)
        {
            string strSql = "select count(*) from Dd_Admin where Admin_name=@Stu_Sid and Admin_Pwd=@User_Pwd";
            SqlParameter[] parameters ={
					new SqlParameter("@Stu_Sid", SqlDbType.Char,12),
					new SqlParameter("@User_Pwd", SqlDbType.VarChar,50)};
            parameters[0].Value = _userName;
            parameters[1].Value = _userPsw;
            return DbHelperSQL.GetExists(strSql, parameters);
        }
        /// <summary>
        /// MD5加密算法
        /// </summary>
        /// <param name="strPsw">用户名密码</param>
        /// <returns>加密后的结果</returns>
        public string MD5(string strPsw)
        {
            MD5 md5 = new MD5CryptoServiceProvider();
            byte[] data = Encoding.Default.GetBytes(strPsw);//将字符编码为一个字节序列
            byte[] md5data = md5.ComputeHash(data);//计算data字节的哈希值
            md5.Clear();
            string str = "";
            for (int i = 0; i < md5data.Length; i++)
            {
                str += md5data[i].ToString("x").PadLeft(2, '0');
            }
            return str;
        }
    }
}